<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MStageproperityDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MStageproperity 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mStageproperity primary key
 	 */
	public function delete($stageProperityId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MStageproperity mStageproperity
 	 */
	public function insert($mStageproperity);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MStageproperity mStageproperity
 	 */
	public function update($mStageproperity);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByInitialValue($value);

	public function queryByStageId($value);

	public function queryByUserId($value);

	public function queryByBranchId($value);

	public function queryByStageProperityDate($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByInitialValue($value);

	public function deleteByStageId($value);

	public function deleteByUserId($value);

	public function deleteByBranchId($value);

	public function deleteByStageProperityDate($value);

	public function deleteByDel($value);


}
?>